<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Parametros</title>
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/metro-orange/easyui.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/mobile.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/icon.css">  
    <link href="../../css/estilo.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.min.js"></script>  
    <script type="text/javascript" src="../../js/jquery-1.8.0.min.js"></script>
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.min.js"></script> 
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.mobile.js"></script>
      <script type="text/javascript" src="../../jquery-easyui-1.4.5/locale/easyui-lang-es.js"></script>    


    
	<script type="text/javascript">
	
	function filtro(){  
		    $('#dg').datagrid('load',{  
		        defecto_nombreFiltro: $('#defecto_nombreFiltro').val(), 
				defecto_estadoFiltro: $('#defecto_estadoFiltro').combobox('getValue'), 
		    });
			 $('#dlgFiltro').dialog('close'); 
			 $('#defecto_nombreFiltro').val('');
			 $('#defecto_estadoFiltro').combobox('setValue','');	 
		}  
		
		var url;
		function nuevoReg(){
			$('#dlg').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fm').form('clear');
			url = 'sqlguardar.php';
		}
		function editarReg(){
			var row = $('#dg').datagrid('getSelected');
			if (row){
				$('#dlg').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				url = 'sqlactualizar.php?id='+row.defecto_id;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

        function guardarReg(){
			$('#fm').form('submit',{
				url: url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlg').dialog('close');		// close the dialog
						$('#dg').datagrid('reload');	// reload the user data
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
		}
		function cambiarEstado(){
			var row = $('#dg').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea cambiar el estado del registro?',function(r){
					if (r){
						$.post('sqlestado.php',{id:row.id,defecto_estado:row.defecto_estado},function(result){
							if (result.success){
								$('#dg').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		$(function cargarCboEspecies(){
			$('#cboespecies').combogrid('clear');
			$('#cboespecies').combogrid({
				panelWidth:400,
				url:'sqlcboespecies.php',
				idField:'especie_cod',
				textField:'especie_nombre',
				mode:'remote',
				fitColumns:true,
				columns:[[
					{field:'especie_cod',title:'Codigo',width:20},
					{field:'especie_nombre',title:'Nombre',width:40}
				]]
			});
		});

	</script>
 
    
    </head>

<body>
	<div class="easyui-navpanel">
    <header>
        <div class="m-toolbar">
            <div class="m-title">Parametros</div>
        </div>
        <div class="m-left">
                    <a href="#" class="easyui-linkbutton m-back" data-options="plain:true,outline:true,back:true">Back</a>
                </div>
    </header>
	<table id="dg" title="Parametros" class="easyui-datagrid" url="sqllistar.php" border="0" toolbar="#toolbar" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:15,pageList:[5,10,15,20]">
	<thead>
		<tr>
			<th field="defecto_nombre" width="200">Parametro</th>
	        <th field="defecto_estado" width="200">Estado</th>
		</tr>
	</thead>
	</table>

	<div id="toolbar">
		<div style ="float:left">
			<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="nuevoReg()">Nuevo</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarReg()">Editar</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-estado" plain="true" onclick="cambiarEstado()">Cambiar Estado</a>
		</div>
		<div style="float:right">
	    	<a href="#" class="easyui-linkbutton"  iconCls="icon-filtro" plain="true" onclick="$('#dlgFiltro').dialog('open').dialog('setTitle','Filtro')">Filtrar</a>
	        <a href="#" class="easyui-linkbutton"  iconCls="icon-filtroCancelar" plain="true" onclick="filtro()">Mostrar Todos</a>
	    </div>	
	</div>
	<footer>
        <div class="m-toolbar">
            <div class="m-title">Control Proceso Inglobo</div>
        </div>
    </footer>
</div>
<div id="dlg" class="easyui-dialog" style="width:700px;height:auto;padding:10px 10px" closed="true" buttons="#dlg-buttons" modal="true">


	
	<form id="fm" method="post" novalidate>
    <table border="0" width="100%">
  <tr>
    <td><div class="ftitle">Información de Parametros</div></td>
    </tr>
  <tr>
    <td>
     	<div class="fitem">
           	<label>Nombre:</label>
			<input name="defecto_nombre" class="easyui-validatebox" size="35" maxlength="350">
          </div>
     	<div class="fitem">
     	  
   	  </div>
    </td>
    </tr>
  <tr>
    <td><div class="ftitle">Procesos Asociados</div></td>
    </tr>
  <tr>
    <td>
      <div class="fitem">
		  <?php
          	include 'sqlcheckparametros.php';
          ?>
      </div>
    </td>
    </tr>
  <tr>
    <td><div class="ftitle">Especies Asociadas</div></td>
    </tr>
  <tr>
    <td>
	    <?php
    		include 'sqlcheckcategorias_especies.php';
        ?>
    </td>
    </tr>
</table>
		
       
            
	</form>
</div>
 <div id="dlg-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarReg()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlg').dialog('close')">Cancelar</a>
</div>

<div id="dlgFiltro" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgFiltro-buttons" modal="true">
			
    	<div class="fitem">
    		<label>Nombre:</label>
            <input id="defecto_nombreFiltro" class="easyui-validatebox">
    	</div>
    	<div class="fitem">
    		<label>Estado:</label>
            <input id="defecto_estadoFiltro" class="easyui-combobox" editable="false" data-options="valueField:'id',textField:'texto',url:'estado.json',panelHeight:'auto'">
    	</div>
        <br />
</div>
<div id="dlgFiltro-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="filtro()">Filtrar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgFiltro').dialog('close')">Cancelar</a>
</div>   


</body>
</html>