<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Variedad</title>
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/metro-orange/easyui.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/mobile.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/icon.css">  
    <link href="../../css/estilo.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.min.js"></script>  
    <script type="text/javascript" src="../../js/jquery-1.8.0.min.js"></script>
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.min.js"></script> 
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.mobile.js"></script>
      <script type="text/javascript" src="../../jquery-easyui-1.4.5/locale/easyui-lang-es.js"></script>    
</head>

<body>
	 <div class="easyui-navpanel">
    <header>
        <div class="m-toolbar">
            <div class="m-title">Variedad</div>
        </div>
        <div class="m-left">
                    <a href="#" class="easyui-linkbutton m-back" data-options="plain:true,outline:true,back:true">Back</a>
                </div>
    </header>
	<table id="dgvariedad" title="Variedad" class="easyui-datagrid" url="sqllistar.php" border="0" toolbar="#toolbar" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:15,pageList:[5,10,15,20]">
	<thead>
		<tr>
	        <th field="variedad_cod" width="95">Código</th>
	        <th field="variedad_nombre" width="100">Nombre</th>
	        <th field="especie_cod" width="100">Especie</th>
	        <th field="especie_nombre" width="100">Especie Nom</th>
	        <th field="estado" width="100">Estado</th>
		</tr>
	</thead>
	</table>

	<div id="toolbar">
		<div style ="float:left">
			<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="nuevoReg()">Nuevo</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarReg()">Editar</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-estado" plain="true" onclick="CambiarEstado()">Cambiar Estado</a>
		</div>
	<div style="float:right">
	    	<a href="#" class="easyui-linkbutton"  iconCls="icon-filtro" plain="true" onclick="$('#dlgFiltro').dialog('open').dialog('setTitle','Filtro')">Filtrar</a>
	        <a href="#" class="easyui-linkbutton"  iconCls="icon-filtroCancelar" plain="true" onclick="filtro()">Mostrar Todos</a>
	    </div>	
	</div>
	<footer>
        <div class="m-toolbar">
            <div class="m-title">Control Proceso Inglobo</div>
        </div>
    </footer>
</div>
    
<div id="dlgform" class="easyui-dialog" style="width:500px;height:auto;padding:10px 10px" closed="true" buttons="#dlg-buttons" modal="true">

	<div class="ftitle">Información de Variedad</div>
	<form id="fm" method="post" novalidate>
		<table width="350" border="0" cellpadding="5">
        	<tr>
            	<td colspan="2">Datos Variedad</td>
            </tr>
            <tr>
            	<td>Código</td>
                <td><input name="variedad_cod" id="variedad_cod" class="easyui-validatebox" required="required" maxlength="50" style="width:250px;"></td>
            </tr>
            <tr>
            	<td>Nombre</td>
                <td><input name="variedad_nombre" id="variedad_nombre" class="easyui-validatebox" required="required" maxlength="50" style="width:250px;"></td>
            </tr>
             <tr>
            	<td>Especie</td>
                <td><input name="especie_cod" id="especie_cod" required="required"  style="width:250px;"></td>
            </tr>
        </table>          
	</form>
</div>
 <div id="dlg-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarReg()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgform').dialog('close')">Cancelar</a>
</div>

<div id="dlgFiltro" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgFiltro-buttons" modal="true">
			
    	<div class="fitem">
    		<label>Codigo:</label>
            <input id="packing_cod_filtro" class="easyui-validatebox">
    	</div>
        <div class="fitem">
           	<label>Nombre:</label>
			 <input id="packing_nombre_filtro" class="easyui-validatebox">
			</div>
        <br />
</div>
<div id="dlgFiltro-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="filtro()">Filtrar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgFiltro').dialog('close')">Cancelar</a>
</div>   
<!--comienza las funciones-->
<script type="text/javascript">
	
	function filtro(){  
		    $('#dgvariedad').datagrid('load',{  
        		
		        packing_cod_filtro: $('#packing_cod_filtro').val(), 
				packing_nombre_filtro: $('#packing_nombre_filtro').val(),
		    });
			 $('#dlgFiltro').dialog('close'); 
			 $('#packing_cod_filtro').val('');
			 $('#packing_nombre_filtro').val('');
		}  
		
		var url;
		function nuevoReg(){
			$('#dlgform').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fm').form('clear');
			$('#variedad_cod').attr("disabled",false);
			$('#variedad_cod').focus();
			url = 'sqlguardar.php';
		}
		function editarReg(){
			var row = $('#dgvariedad').datagrid('getSelected');
			if (row){
				$('#dlgform').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				$('#variedad_cod').attr("disabled",true);
				$('#variedad_nombre').focus();
				//$('#perfil').combobox('getValue');
				url = 'sqlactualizar.php?id='+row.variedad_cod;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

        function guardarReg(){
			$('#fm').form('submit',{
				url: url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgform').dialog('close');		// close the dialog
						$('#dgvariedad').datagrid('reload');	// reload the user data
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
		}
		function CambiarEstado(){
			var row = $('#dgvariedad').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea cambiar el estado del registro?',function(r){
					if (r){
						$.post('sqlestado.php',{id:row.variedad_cod,estado:row.estado},function(result){
							if (result.success){
								$('#dgvariedad').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		//cargar datagrid, comboox
		$(function(){ 
			$('#especie_cod').combogrid({
                panelWidth: 430,
                mode: 'remote',
                url: 'especie_grid.php',
                idField: 'especie_cod',
                textField: 'especie_nombre',
                columns: [[
                    {field:'especie_cod',title:'Codigo',width:'30%',sortable:true},
                    {field:'especie_nombre',title:'Nombre',width:'60%',sortable:true}
                ]]
             });
		});
			
		function formato_rut(texto, activo) { 
			var invertido = ""; 
			var dtexto = ""; 
			var cnt = 0; 
			var i=0; 
			var j=0; 
			var largo = "";     
			if (activo) { 
					  texto = formato_rut(texto, false) 
					  crut = formato_rut(texto, false)
					  largo = texto.length; 
					  largo2 = texto.length; 
					if (largo > 0 )
					{
					 for ( i=0; i <crut.length ; i++ )
						if ( crut.charAt(i) != ' ' && crut.charAt(i) != '.' && crut.charAt(i) != '-' )
						{
							tmpstr = tmpstr + crut.charAt(i);
						}
						rut = tmpstr;
						largo2 = crut.length;
					
						if ( largo2 > 2 )
						
							rut = crut.substring(0, largo2 - 1);
						
						else
							rut = crut.charAt(0);
					
						    dv = crut.charAt(largo2-1);
					    if ( rut == null || dv == null )
						return 0;
					
						var dvr = '0';
						suma = 0;
						mul  = 2;
					    
						for (i= rut.length-1 ; i>= 0; i--)
						{
							suma = suma + rut.charAt(i) * mul;
							if (mul == 7)
								mul = 2;
							else
								mul++;
						}
					
						res = suma % 11;
						
						if (res==1)
							dvr = 'k';
						else if (res==0)
							dvr = '0';
						else
						{
							dvi = 11-res;
							dvr = dvi + "";
						}
					
						if ( dvr != dv.toLowerCase() )
						{
							$.messager.alert('Error','El Rut Ingreso es Invalido','error');
							
							return "";
						}
						//alert('El Rut Ingresado es Correcto!');
//						Objeto.focus()
//						return true; 
					  for ( i=(largo-1),j=0; i>=0; i--,j++ ) 
						invertido = invertido + texto.charAt(i);           
					  dtexto = dtexto + invertido.charAt(0); 
					  dtexto = dtexto + '-';           
							  for ( i=1,j=2; i<largo; i++,j++ ) 
							  { 
								//alert("i=[" + i + "] j=[" + j +"]" ); 
										if ( cnt == 3 ) 
										{ 
										  dtexto = dtexto + '.'; 
										  j++; 
										  dtexto = dtexto + invertido.charAt(i); 
										  cnt = 1; 
										} 
										else 
										{  
										  dtexto = dtexto + invertido.charAt(i); 
										  cnt++; 
										} 
							  } 
					  invertido = ""; 
					  for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ ) 
						invertido = invertido + dtexto.charAt(i); 
					  if (invertido == '-') invertido = "" 
					  texto = invertido; 
					 					 
					 
					 
				} else { 
				
				$.messager.alert('Error','El Rut Ingreso es Invalido','error');
				return "";
			
				}
				} else { 
					var tmpstr = ""; 
					for ( i=0; i < texto.length ; i++ ) 
					if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' ) 
						tmpstr = tmpstr + texto.charAt(i); 
					texto = tmpstr; 
				} 
				return texto; 
			}

	</script>
</body>
</html>