<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Normas</title>
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/metro-orange/easyui.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/mobile.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/icon.css">  
    <link href="../../css/estilo.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.min.js"></script>  
    <script type="text/javascript" src="../../js/jquery-1.8.0.min.js"></script>
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.min.js"></script> 
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.mobile.js"></script>
      <script type="text/javascript" src="../../jquery-easyui-1.4.5/locale/easyui-lang-es.js"></script>    
</head>

<body>
	<div class="easyui-navpanel">
    <header>
        <div class="m-toolbar">
            <div class="m-title">NORMAS</div>
        </div>
        <div class="m-left">
         	<a href="#" class="easyui-linkbutton m-back" data-options="plain:true,outline:true,back:true">Back</a>
         </div>
        
    </header>
	<table id="dgnorma" title="Normas" class="easyui-datagrid" url="sqllistar.php" toolbar="#toolbar" border="0"  pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:15,pageList:[5,10,15,20]">
	<thead>
		<tr>
	        <th field="norma_id" width="95">Codigo</th>
	        <th field="norma_descripcion" width="100">Nombre</th>
	        <th field="exportador_nombre" width="100">Exportador</th>
	        <th field="especie_nombre" width="100">Especie</th>
	        <th field="num_norma" width="100">N Normas</th>
	        <th field="anio_norma" width="100">año</th>
	        <th field="tipo_norma" width="100">Tipo</th>
	        <th field="estado" width="100">Estado</th>
	        <th field="sincro" width="100">sincro</th>
	        <th field="pdf" width="100">PDF</th>
	        <th field="excel" width="100">Excel</th>
		</tr>
	</thead>
	</table>
	<div id="toolbar">
		<div style ="float:left">
			<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="nuevoReg()">Nuevo</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarReg()">Editar</a>
		    <a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="CopiarNorma()">Copiar Norma</a>
		    <a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="VerGrid()">Asignar Defectos</a>
		    <a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="AsociarParametro()">Parametro</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-estado" plain="true" onclick="CambiarEstado()">Cambiar Estado</a>
		</div>
		<div style="float:right">
		    	<a href="#" class="easyui-linkbutton"  iconCls="icon-filtro" plain="true" onclick="$('#dlgFiltro').dialog('open').dialog('setTitle','Filtro')">Filtrar</a>
		        <a href="#" class="easyui-linkbutton"  iconCls="icon-filtroCancelar" plain="true" onclick="filtro()">Mostrar Todos</a>
		</div>	
	</div>
    <footer>
        <div class="m-toolbar">
            <div class="m-title">Control Proceso Inglobo</div>
        </div>
    </footer>
</div>
    
<div id="dlgform" class="easyui-dialog" style="width:500px;height:auto;padding:10px 10px" closed="true" buttons="#dlg-buttons" modal="true">

	<div class="ftitle">Información de Norma</div>
	<form id="fm" method="post" novalidate>
		<table width="350" border="0" cellpadding="5">
        	<tr>
            	<td colspan="2">Datos Norma</td>
            </tr>
            <tr>
            	<td>Nombre</td>
                <td><input name="norma_descripcion" id="norma_descripcion" class="easyui-validatebox" required="required" maxlength="50" style="width:250px;"></td>
            </tr>
             <tr>
            	<td>Exportador</td>
                <td><input id="exportador_cod" name="exportador_cod" class="easyui-combogrid" editable="false" style="width:250px;" data-options="
            panelWidth:430,
            idField:'exportador_cod',
            textField:'exportador_nombre',
            url:'cboexportadorgrid.php',
            columns:[[
                {field:'exportador_cod',title:'Codigo',width:100,sortable:true},
                {field:'exportador_nombre',title:'Nombre',width:300,sortable:true}
            ]],
            onSelect: function(rec){
            	var g = $('#exportador_cod').combogrid('grid');
				var r = g.datagrid('getSelected');
                llenar_especie(r.exportador_cod);
               $('#especie_cod').combogrid('clear');
            }" required="required">
            <!--<input id="exportador_cod" name="exportador_cod" editable="false" style="width:250px;">--></td>
            </tr>
             <tr>
            	<td>Especie</td>
                <td><input id="especie_cod" name="especie_cod" editable="false" style="width:250px;" required="required"></td>
            </tr>
             <tr>
            	<td>Num Normas</td>
                <td><input name="num_norma" id="num_norma" class="easyui-validatebox" required="required" maxlength="50" style="width:250px;"></td>
            </tr>
            <tr>
            	<td>Año</td>
                <td><input name="anio_norma" id="anio_norma" class="easyui-validatebox" required="required" maxlength="50" style="width:250px;"></td>
            </tr>
            <tr>
            	<td>Sincro</td>
                <td><input id="sincro" name="sincro" class="easyui-combobox" url="sincro.json" panelHeight="auto" editable="false" valueField="id" textField="texto" required></td>
            </tr>
        </table>          
	</form>
</div>
 <div id="dlg-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarReg()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgform').dialog('close')">Cancelar</a>
</div>

<div id="dlgFiltro" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgFiltro-buttons" modal="true">
		
        <div class="fitem">
           	<label>Tipo Planilla:</label>
			<input id="tipo_planilla_filtro" name="tipo_planilla_filtro" class="easyui-combobox" url="CboTipoplanilla.json" panelHeight="auto" editable="false" valueField="id" textField="texto">
        </div>
        <br />
</div>
<div id="dlgFiltro-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="filtro()">Filtrar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgFiltro').dialog('close')">Cancelar</a>
</div>  
<div id="dlgVerwin" class="easyui-window" title="Modal Window" data-options="modal:true,closed:true,iconCls:'icon-save',closable:true" style="width:900px;height:465px;padding:10px;">
        The window content.
</div>

 <!--DATAGRID DE PARAMETROS-->
<div id="dlgformcrearparametro" class="easyui-dialog" style="width:750px;height:450px;padding:10px 10px" closed="true" buttons="#dlg-buttonscrearparametro" modal="true">
    <table id="dgparametro" title="Parametros" class="easyui-datagrid" border="0" toolbar="#toolbar2" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:6,pageList:[6,15,20]">
    </table>

    <div id="toolbar2">
        <div style ="float:left">
            <a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="NuevoParametro()">Agregar</a>
            <a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarRegParametro()">Editar</a>
            <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" plain="true" onclick="EliminarParametro()">Quitar</a>
        </div>
    </div>
</div>
 <div id="dlg-buttonscrearparametro" style="width:inherit;text-align:center;">
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgformcrearparametro').dialog('close')">Cerrar</a>
</div>

<div id="dlgparnuevo" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgparnuevo-buttons" modal="true">

	<div class="ftitle">Información de Parametro</div>
	<form id="fmparametro" method="post" novalidate>
		
        <div class="fitem">
           	<label>Parametro:</label>
			<input id="id_parametro" name="id_parametro" editable="false" style="width:250px;">
        </div> 
        <div class="fitem">
           	<label>Orden:</label>
			<input type="text" class="easyui-numberbox" name="orden_parametro" id="orden_parametro" data-options="min:0,precision:0" required="required">
        </div> 
                
	</form>
</div>
 <div id="dlgparnuevo-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarParametro()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgparnuevo').dialog('close')">Cancelar</a>
</div>

 
<!--comienza las funciones-->
<script type="text/javascript">
	
	function filtro(){  
		    $('#dgnorma').datagrid('load',{  
        		
		        
				tipo_planilla_filtro: $('#tipo_planilla_filtro').combobox('getValue'), 
				
		    });
			 $('#dlgFiltro').dialog('close'); 
			 
			 $('#tipo_planilla_filtro').combobox('setValue','');	 
			 
		}  
		
		var url;
		function nuevoReg(){
			$('#dlgform').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fm').form('clear');
			$('#especie_cod').combogrid('enable');
			$('#exportador_cod').combogrid('enable');
			$('#norma_descripcion').focus();
			url = 'sqlguardar.php';
		}
		function editarReg(){
			var row = $('#dgnorma').datagrid('getSelected');
			if (row){
				$('#dlgform').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				$('#especie_cod').combogrid('disable');
				$('#exportador_cod').combogrid('disable');
				$('#norma_descripcion').focus();
				//$('#perfil').combobox('getValue');
				url = 'sqlactualizar.php?id='+row.norma_id;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		function CopiarNorma(){
			var row = $('#dgnorma').datagrid('getSelected');
			if (row){
				$('#dlgform').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				$('#especie_cod').combogrid('disable');
				$('#exportador_cod').combogrid('disable');
				$('#norma_descripcion').focus();
				//$('#perfil').combobox('getValue');
				url = 'sqlcopiar.php?id='+row.norma_id;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

        function guardarReg(){
			$('#fm').form('submit',{
				url: url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgform').dialog('close');		// close the dialog
						$('#dgnorma').datagrid('reload');	// reload the user data
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
		}
		function CambiarEstado(){
			var row = $('#dgnorma').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','驴Esta seguro que desea cambiar el estado del registro?',function(r){
					if (r){
						$.post('sqlestado.php',{id:row.norma_id,estado:row.estado},function(result){
							if (result.success){
								$('#dgnorma').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
			
		//cargar datagrid, comboox
		$(function(){ 
			$('#especie_cod').combogrid({
				panelWidth: 430,
				mode: 'remote',
				url: 'cboespeciegrid2.php',
				idField: 'especie_cod',
				textField: 'especie_nombre',
				columns: [[
					{field:'especie_cod',title:'Codigo',width:100,sortable:true},
					{field:'especie_nombre',title:'Nombre',width:300,sortable:true}
				]]
			});
			$('#id_parametro').combogrid({
				panelWidth: 430,
				mode: 'remote',
				url: 'cboparametrogrid.php',
				idField: 'id_parametro',
				textField: 'parametro_nombre',
				columns: [[
					{field:'id_parametro',title:'Codigo',width:100,sortable:true},
					{field:'parametro_nombre',title:'Nombre',width:300,sortable:true}
				]]
			});
		});	
		
		function llenar_especie(valor){  
            $('#especie_cod').combogrid({
				panelWidth: 430,
				mode: 'remote',
				url: 'cboespeciegrid.php?exportador_cod='+valor,
				idField: 'especie_cod',
				textField: 'especie_nombre',
				columns: [[
					{field:'especie_cod',title:'Codigo',width:100,sortable:true},
					{field:'especie_nombre',title:'Nombre',width:300,sortable:true}
				]]
			}); 
			     		 
        } 

		//VER GRID
		function VerGrid(){
			var row = $('#dgnorma').datagrid('getSelected');
			if (row){
				
					
					$('#dlgVerwin').window('open');  // open a window
					$('#dlgVerwin').window('refresh', 'carga_datagrid.php?norma_id='+row.norma_id+'&especie_cod='+row.especie_cod);
				
				
				//cargarDgDef(row.norma_id);
				//$('#dlgVerwin').window('close');  
			}
		}
		
		function cargarDgDef(id_norma){
			<?php include ('carga_datagrid2.php');
			echo $strDgjava;
			?>
		}
		
		
		//FUNCIONES DE ASOCIAR PARAMETRO
		function AsociarParametro(){
			var row = $('#dgnorma').datagrid('getSelected');
			if (row){
				$('#dlgformcrearparametro').dialog('open').dialog('setTitle','Nuevo Registro');
				cargarParametro(row.norma_id);
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

		function editarRegParametro(){
			var row = $('#dgparametro').datagrid('getSelected');
			if (row){
				$('#dlgparnuevo').dialog('open').dialog('setTitle','Editar Registro');
				$('#fmparametro').form('clear');
				$('#fmparametro').form('load',row);
				//$('#perfil').combobox('getValue');
				url = 'actualizar_parametro.php?id='+row.id_detalle;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		function cargarParametro(codigo){
			$('#dgparametro').datagrid({
				url:'sqllistarparametro.php?codigo='+codigo,
				columns:[[
					{field:'id_parametro',title:'Id',width:400},
					{field:'parametro_nombre',title:'Nombre',width:400},
					{field:'orden_parametro',title:'Orden',width:400}									
				]]
			});
		}
		
		function NuevoParametro(){
			var row = $('#dgnorma').datagrid('getSelected');
			$('#dlgparnuevo').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fmparametro').form('clear');
			url = 'sqlguardarparametro.php?norma_id='+row.norma_id;
		}
		
		function guardarParametro(){
			var row = $('#dgnorma').datagrid('getSelected');
			if (row){				
				$('#fmparametro').form('submit',{
				url:url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgparnuevo').dialog('close');		// close the dialog	
						$('#dgparametro').datagrid('reload');
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
			}
		}
		
		function EliminarParametro(){
			var row = $('#dgparametro').datagrid('getSelected');
			var row2 = $('#dgnorma').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea Quitar el registro?'+row.id_detalle,function(r){
					if (r){
						$.post('sqlquitarparametro.php',{id:row.id_detalle,norma_id:row2.norma_id, id_parametro:row.id_parametro},function(result){
							if (result.success){
								$('#dgparametro').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json'); 
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

	</script>
</body>
</html>