<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Procesos</title>
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/metro-orange/easyui.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/mobile.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/icon.css">  
    <link href="../../css/estilo.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.min.js"></script>  
    <script type="text/javascript" src="../../js/jquery-1.8.0.min.js"></script>
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.min.js"></script> 
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.mobile.js"></script>
      <script type="text/javascript" src="../../jquery-easyui-1.4.5/locale/easyui-lang-es.js"></script>    
</head>

<body>
	<div class="easyui-navpanel">
    <header>
        <div class="m-toolbar">
            <div class="m-title">Procesos</div>
        </div>
        <div class="m-left">
                    <a href="#" class="easyui-linkbutton m-back" data-options="plain:true,outline:true,back:true">Back</a>
                </div>
    </header>
	<table id="dgparametros" title="Procesos" class="easyui-datagrid" url="sqllistar.php" border="0" toolbar="#toolbar" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:15,pageList:[5,10,15,20]">
	<thead>
		<tr>
	        <th field="id_parametro" width="95">Código</th>
	        <th field="parametro_nombre" width="100">Nombre</th>
	        <th field="parametro_estado" width="100">Estado</th>
		</tr>
	</thead>
	</table>

	<div id="toolbar">
		<div style ="float:left">
			<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="nuevoReg()">Nuevo</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarReg()">Editar</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-estado" plain="true" onclick="CambiarEstado()">Cambiar Estado</a>
		</div>
		<div style="float:right">
		    	<a href="#" class="easyui-linkbutton"  iconCls="icon-filtro" plain="true" onclick="$('#dlgFiltro').dialog('open').dialog('setTitle','Filtro')">Filtrar</a>
		        <a href="#" class="easyui-linkbutton"  iconCls="icon-filtroCancelar" plain="true" onclick="filtro()">Mostrar Todos</a>
		   
		 </div>	
    </div>
<footer>
        <div class="m-toolbar">
            <div class="m-title">Control Proceso Inglobo</div>
        </div>
    </footer>
</div>
    
<div id="dlgform" class="easyui-dialog" style="width:500px;height:auto;padding:10px 10px" closed="true" buttons="#dlg-buttons" modal="true">

	<div class="ftitle">Información de Procesos</div>
	<form id="fm" method="post" novalidate>
		<table width="350" border="0" cellpadding="5">
        	<tr>
            	<td colspan="2">Datos Procesos</td>
            </tr>
            <tr>
            	<td>Nombre</td>
                <td><input name="parametro_nombre" id="parametro_nombre" class="easyui-validatebox" required="required" maxlength="50" style="width:250px;"></td>
            </tr>
        </table>          
	</form>
</div>
 <div id="dlg-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarReg()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgform').dialog('close')">Cancelar</a>
</div>

<div id="dlgFiltro" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgFiltro-buttons" modal="true">
		<div class="fitem">
    		<label>Rut:</label>
            <input id="usuario_rut_filtro" class="easyui-validatebox">
    	</div>	
    	<div class="fitem">
    		<label>Nombre:</label>
            <input id="usuario_nombre_filtro" class="easyui-validatebox">
    	</div>
        <div class="fitem">
           	<label>Tipo:</label>
			<input id="usuario_tipo_filtro" name="usuario_tipo_filtro" class="easyui-combobox" url="CboTipoFiltro.json" panelHeight="auto" editable="false" valueField="value" textField="text" required="required">
        </div>
        <div class="fitem">
           	<label>Estado:</label>
			<input id="usuario_estado_filtro" name="usuario_estado_filtro" class="easyui-combobox" url="CboEstado.json" panelHeight="auto" editable="false" valueField="value" textField="text" required="required">
        </div>
        <div class="fitem">
           	<label>Perfil:</label>
			<input name="perfilFiltro"  id="perfilFiltro" class="easyui-combobox" editable="false" data-options= "valueField:'tipousuario_id',textField:'tipousuario_nombre',url:'sqlcboperfilesFiltro.php',panelHeight:'auto'" >
        </div>
        <br />
</div>
<div id="dlgFiltro-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="filtro()">Filtrar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgFiltro').dialog('close')">Cancelar</a>
</div>   
<!--comienza las funciones-->
<script type="text/javascript">
	
	function filtro(){  
		    $('#dgparametros').datagrid('load',{  
        		
		        usuario_rut_filtro: $('#usuario_rut_filtro').val(), 
				usuario_nombre_filtro: $('#usuario_nombre_filtro').val(),
				usuario_tipo_filtro: $('#usuario_tipo_filtro').combobox('getValue'), 
				usuario_estado_filtro: $('#usuario_estado_filtro').combobox('getValue'), 
				perfilFiltro: $('#perfilFiltro').combobox('getValue'),
		    });
			 $('#dlgFiltro').dialog('close'); 
			 $('#usuario_rut_filtro').val('');
			 $('#usuario_nombre_filtro').val('');
			 $('#usuario_tipo_filtro').combobox('setValue','');	 
			 $('#usuario_estado_filtro').combobox('setValue','');	
			 $('#perfilFiltro').combobox('setValue','');
		}  
		
		var url;
		function nuevoReg(){
			$('#dlgform').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fm').form('clear');
			$('#parametro_nombre').focus();
			url = 'sqlguardar.php';
		}
		function editarReg(){
			var row = $('#dgparametros').datagrid('getSelected');
			if (row){
				$('#dlgform').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				$('#parametro_nombre').focus();
				//$('#perfil').combobox('getValue');
				url = 'sqlactualizar.php?id='+row.id_parametro;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

        function guardarReg(){
			$('#fm').form('submit',{
				url: url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgform').dialog('close');		// close the dialog
						$('#dgparametros').datagrid('reload');	// reload the user data
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
		}
		function CambiarEstado(){
			var row = $('#dgparametros').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea cambiar el estado del registro?',function(r){
					if (r){
						$.post('sqlestado.php',{id:row.id_parametro,estado:row.parametro_estado},function(result){
							if (result.success){
								$('#dgparametros').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		

	</script>
</body>
</html>