<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Planillas</title>
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/metro-orange/easyui.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/mobile.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/icon.css">  
    <link href="../../css/estilo.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.min.js"></script>  
    <script type="text/javascript" src="../../js/jquery-1.8.0.min.js"></script>
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.min.js"></script> 
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.mobile.js"></script>
      <script type="text/javascript" src="../../jquery-easyui-1.4.5/locale/easyui-lang-es.js"></script>    
</head>

<body>
<div class="easyui-navpanel">
    <header>
        <div class="m-toolbar">
            <div class="m-title">Panel Header</div>
        </div>
        <div class="m-left">
                    <a href="#" class="easyui-linkbutton m-back" data-options="plain:true,outline:true,back:true">Back</a>
                </div>
    </header>
    <table id="dgclientes" title="Clientes" class="easyui-datagrid" url="sqllistar.php" border="0" toolbar="#toolbar" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:15,pageList:[5,10,15,20]">
	<thead>
		<tr>
	        <th field="cliente_cod" width="95">Código</th>
	        <th field="cliente_rut" width="100">Rut</th>
	        <th field="cliente_nombre" width="100">Nombre</th>
	        <th field="cliente_estado" width="100">Estado</th>
		</tr>
	</thead>
	</table>

	<div id="toolbar">
		<div style ="float:left">
			<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="nuevoReg()">Nuevo</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarReg()">Editar</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-estado" plain="true" onclick="CambiarEstado()">Cambiar Estado</a>
		</div>
		<div style="float:right">
		    	<a href="#" class="easyui-linkbutton"  iconCls="icon-filtro" plain="true" onclick="$('#dlgFiltro').dialog('open').dialog('setTitle','Filtro')">Filtrar</a>
		        <a href="#" class="easyui-linkbutton"  iconCls="icon-filtroCancelar" plain="true" onclick="filtro()">Mostrar Todos</a>
		</div>	
    </div>
    <footer>
        <div class="m-toolbar">
            <div class="m-title">Control Proceso Inglobo</div>
        </div>
    </footer>
</div>

    
<div id="dlgform" class="easyui-dialog" style="width:500px;height:auto;padding:10px 10px" closed="true" buttons="#dlg-buttons" modal="true">

	<div class="ftitle">Información de Clientes</div>
	<form id="fm" method="post" novalidate>
		<table width="350" border="0" cellpadding="5">
        	<tr>
            	<td colspan="2">Datos Cliente</td>
            </tr>
            <tr>
            	<td>Código</td>
                <td><input name="cliente_cod" id="cliente_cod" class="easyui-validatebox" required="required" maxlength="50" style="width:100%;"></td>
            </tr>
        	<tr>
            	<td>Rut:</td>
                <td><input name="cliente_rut" id="cliente_rut" class="easyui-validatebox" maxlength="12" style="width:100%;"></td>
            <tr>
            	<td>Nombre</td>
                <td><input name="cliente_nombre" id="cliente_nombre" class="easyui-validatebox" required="required" maxlength="50" style="width:100%;"></td>
            </tr>
        </table>          
	</form>
</div>
 <div id="dlg-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarReg()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgform').dialog('close')">Cancelar</a>
</div>

<div id="dlgFiltro" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgFiltro-buttons" modal="true">
		
</div>
<div id="dlgFiltro-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="filtro()">Filtrar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgFiltro').dialog('close')">Cancelar</a>
</div>   
<!--comienza las funciones-->
<script type="text/javascript">
	
	function filtro(){  
		    $('#dgclientes').datagrid('load',{  
        		
		        usuario_rut_filtro: $('#usuario_rut_filtro').val(), 
				usuario_nombre_filtro: $('#usuario_nombre_filtro').val(),
				usuario_tipo_filtro: $('#usuario_tipo_filtro').combobox('getValue'), 
				usuario_estado_filtro: $('#usuario_estado_filtro').combobox('getValue'), 
				perfilFiltro: $('#perfilFiltro').combobox('getValue'),
		    });
			 $('#dlgFiltro').dialog('close'); 
			 $('#usuario_rut_filtro').val('');
			 $('#usuario_nombre_filtro').val('');
			 $('#usuario_tipo_filtro').combobox('setValue','');	 
			 $('#usuario_estado_filtro').combobox('setValue','');	
			 $('#perfilFiltro').combobox('setValue','');
		}  
		
		var url;
		function nuevoReg(){
			$('#dlgform').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fm').form('clear');
			$('#cliente_cod').attr("disabled",false);
			$('#cliente_cod').focus();
			url = 'sqlguardar.php';
		}
		function editarReg(){
			var row = $('#dgclientes').datagrid('getSelected');
			if (row){
				$('#dlgform').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				$('#cliente_cod').attr("disabled",true);
				$('#cliente_nombre').focus();
				//$('#perfil').combobox('getValue');
				url = 'sqlactualizar.php?id='+row.cliente_cod;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

        function guardarReg(){
			$('#fm').form('submit',{
				url: url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgform').dialog('close');		// close the dialog
						$('#dgclientes').datagrid('reload');	// reload the user data
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
		}
		function CambiarEstado(){
			var row = $('#dgclientes').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea cambiar el estado del registro?',function(r){
					if (r){
						$.post('sqlestado.php',{id:row.cliente_cod,estado:row.cliente_estado},function(result){
							if (result.success){
								$('#dgclientes').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		

	</script>
</body>
</html>