<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Planillas</title>
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/metro-orange/easyui.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/mobile.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/icon.css">  
    <link href="../../css/estilo.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.min.js"></script>  
    <script type="text/javascript" src="../../js/jquery-1.8.0.min.js"></script>
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.min.js"></script> 
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.mobile.js"></script>
      <script type="text/javascript" src="../../jquery-easyui-1.4.5/locale/easyui-lang-es.js"></script>    
</head>

<body>
<div class="easyui-navpanel">
    <header>
        <div class="m-toolbar">
            <div class="m-title">Panel Header</div>
        </div>
        <div class="m-left">
                    <a href="#" class="easyui-linkbutton m-back" data-options="plain:true,outline:true,back:true">Back</a>
                </div>
    </header>
	<table id="dgusuario" class="easyui-datagrid" url="sqllistar.php" border="0" toolbar="#toolbar" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:15,pageList:[5,10,15,20]">
	<thead>
		<tr>
	        <th field="usuario_rut" width="95">Rut</th>
	        <th field="usuario_nombre" width="100">Nombre</th>
	        <th field="usuario_apepaterno" width="100">Apellido Paterno</th>
	        <th field="usuario_apematerno" width="100">Apellido Materno</th>
	        <th field="nombre_tipousuario" width="100">Perfil</th>
	        <th field="usuario_mail" width="100">Correo</th>
	        <th field="usuario_telefono" width="100">Telefono</th>
	        <th field="usuario_codinspector" width="100">Código</th>
	        <th field="usuario_folio_inicio" width="100">Folio Inicio</th>
	        <th field="usuario_folio_final" width="100">Folio Final</th>
	        <th field="usuario_folio_saldo" width="100">Folio saldo</th>
	        <th field="usuario_estado" width="100">Estado</th>
	        <th field="ultimo_folio" width="100">Ultimo Folio</th>
		</tr>
	</thead>
	</table>

	<div id="toolbar">
		<div style ="float:left">
			<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="nuevoReg()">Nuevo</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarReg()">Editar</a>
			<a href="#" class="easyui-linkbutton" iconCls="icon-estado" plain="true" onclick="CambiarEstado()">Cambiar Estado</a>
		    <a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="AsociarExportador()">Exportador</a>
	    </div>
	<div style="float:right">
	    	<a href="#" class="easyui-linkbutton"  iconCls="icon-filtro" plain="true" onclick="$('#dlgFiltro').dialog('open').dialog('setTitle','Filtro')">Filtrar</a>
	        <a href="#" class="easyui-linkbutton"  iconCls="icon-filtroCancelar" plain="true" onclick="filtro()">Mostrar Todos</a>
	    </div>	
	</div>
	<footer>
        <div class="m-toolbar">
            <div class="m-title">Control Proceso Inglobo</div>
        </div>
    </footer>
</div>
    
<div id="dlgform" class="easyui-dialog" style="width:500px;height:auto;padding:10px 10px" closed="true" buttons="#dlg-buttons" modal="true">

	<div class="ftitle">Información de Usuarios</div>
	<form id="fm" method="post" novalidate>
		<table border="0" cellpadding="5">
        	<tr>
            	<td colspan="2">Daros Personales</td>
                <td width="10"></td>
                <td colspan="2">Seguridad</td>
            </tr>
        	<tr>
            	<td>Rut:</td>
                <td><input name="usuario_rut" id="usuario_rut" class="easyui-validatebox" required="required" maxlength="12" onblur="this.value =formato_rut(this.value,true)"></td>
               <td></td>
                <td>Perfil</td>
                <td><input name="id_tipousuario"  id="id_tipousuario" class="easyui-combobox" editable="false" required="required" data-options="valueField:'id_tipousuario',textField:'nombre_tipousuario',url:'sqlcboperfiles.php',panelHeight:'auto'" ></td>     
            </tr>
            <tr>
            	<td>Nombre</td>
                <td><input name="usuario_nombre" id="usuario_nombre" class="easyui-validatebox" required="required" maxlength="50"></td>
                <td></td>
                <td>Clave</td>
                <td><input name="usuario_clave" id="usuario_clave" type="password" class="easyui-validatebox" maxlength="50" required="required"></td>
                <td></td>
            </tr>
            <tr>
            	<td>Apellido Paterno:</td>
                <td><input name="usuario_apepaterno" id="usuario_apepaterno" class="easyui-validatebox" required="required" maxlength="50"></td>
                <td></td>
                <td>Folio Inicio</td>
                <td><input name="usuario_folio_inicio" id="usuario_folio_inicio" type="number" class="easyui-validatebox" maxlength="50" required="required"></td>
                <td></td>
            </tr>
            <tr>
            	<td>Apellido Materno:</td>
                <td><input name="usuario_apematerno" id="usuario_apematerno" class="easyui-validatebox" required="required"></td>
                <td></td>
                <td>Folio Final</td>
                <td><input name="usuario_folio_final" id="usuario_folio_final" type="number" class="easyui-validatebox" maxlength="50" required="required"></td>
                <td></td>
            </tr>
           
            <tr>
            	<td>Telefono</td>
                <td><input name="usuario_telefono" id="usuario_telefono" class="easyui-numberbox" precision="0"></td>
                <td></td>
            </tr>
            <tr>
            	<td>Correo</td>
                <td><input name="usuario_mail" id="usuario_mail" class="easyui-validatebox"></td>
                <td></td>
                <td></td>
            </tr>
        </table>          
	</form>
</div>
 <div id="dlg-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarReg()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgform').dialog('close')">Cancelar</a>
</div>

<div id="dlgFiltro" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgFiltro-buttons" modal="true">
		<div class="fitem">
    		<label>Rut:</label>
            <input id="usuario_rut_filtro" class="easyui-validatebox">
    	</div>	
    	<div class="fitem">
    		<label>Nombre:</label>
            <input id="usuario_nombre_filtro" class="easyui-validatebox">
    	</div>
        <div class="fitem">
           	<label>Tipo:</label>
			<input id="usuario_tipo_filtro" name="usuario_tipo_filtro" class="easyui-combobox" url="CboTipoFiltro.json" panelHeight="auto" editable="false" valueField="value" textField="text" required="required">
        </div>
        <div class="fitem">
           	<label>Estado:</label>
			<input id="usuario_estado_filtro" name="usuario_estado_filtro" class="easyui-combobox" url="CboEstado.json" panelHeight="auto" editable="false" valueField="value" textField="text" required="required">
        </div>
        <div class="fitem">
           	<label>Perfil:</label>
			<input name="perfilFiltro"  id="perfilFiltro" class="easyui-combobox" editable="false" data-options= "valueField:'tipousuario_id',textField:'tipousuario_nombre',url:'sqlcboperfilesFiltro.php',panelHeight:'auto'" >
        </div>
        <br />
</div>
<div id="dlgFiltro-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="filtro()">Filtrar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgFiltro').dialog('close')">Cancelar</a>
</div>  

<!--DATAGRID DE EXPORTADORES-->
<div id="dlgformasociarexp" class="easyui-dialog" style="width:750px;height:450px;padding:10px 10px" closed="true" buttons="#dlg-buttonsasociarexp" modal="true">
    <table id="dgexportador" title="Exportadores" class="easyui-datagrid" border="0" toolbar="#toolbar2" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:8,pageList:[8,15,20]">
    </table>

    <div id="toolbar2">
        <div style ="float:left">
            <a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="NuevoExportador()">Agregar</a>
            <a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarExportador()">Editar</a>
            <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" plain="true" onclick="EliminarExportador()">Quitar</a>
        </div>
    </div>
</div>
 <div id="dlg-buttonsasociarexp" style="width:inherit;text-align:center;">
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgformasociarexp').dialog('close')">Cerrar</a>
</div>

<div id="dlgexpnuevo" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgnuevo-buttons" modal="true">

	<div class="ftitle">Información de Exportadores</div>
	<form id="fmexportador" method="post" novalidate>
		
        <div class="fitem">
           	<label>Exportador:</label>
			<input id="aso_exportador_cod" name="aso_exportador_cod" editable="false" style="width:250px;">
        </div>          
	</form>
</div>
 <div id="dlgnuevo-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarExportador()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgexpnuevo').dialog('close')">Cancelar</a>
</div>

<!--comienza las funciones-->
<script type="text/javascript">
	
	function filtro(){  
		    $('#dgusuario').datagrid('load',{  
        		
		        usuario_rut_filtro: $('#usuario_rut_filtro').val(), 
				usuario_nombre_filtro: $('#usuario_nombre_filtro').val(),
				usuario_tipo_filtro: $('#usuario_tipo_filtro').combobox('getValue'), 
				usuario_estado_filtro: $('#usuario_estado_filtro').combobox('getValue'), 
				perfilFiltro: $('#perfilFiltro').combobox('getValue'),
		    });
			 $('#dlgFiltro').dialog('close'); 
			 $('#usuario_rut_filtro').val('');
			 $('#usuario_nombre_filtro').val('');
			 $('#usuario_tipo_filtro').combobox('setValue','');	 
			 $('#usuario_estado_filtro').combobox('setValue','');	
			 $('#perfilFiltro').combobox('setValue','');
		}  
		
		var url;
		function nuevoReg(){
			$('#dlgform').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fm').form('clear');
			$('#usuario_rut').attr("disabled",false);
			$('#usuario_rut').focus();
			url = 'sqlguardar.php';
		}
		function editarReg(){
			var row = $('#dgusuario').datagrid('getSelected');
			if (row){
				$('#dlgform').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				$('#usuario_rut').attr("disabled",true);
				$('#usuario_nombre').focus();
				//$('#perfil').combobox('getValue');
				url = 'sqlactualizar.php?id='+row.usuario_rut;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

        function guardarReg(){
			$('#fm').form('submit',{
				url: url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgform').dialog('close');		// close the dialog
						$('#dgusuario').datagrid('reload');	// reload the user data
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
		}
		function CambiarEstado(){
			var row = $('#dgusuario').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea cambiar el estado del registro?',function(r){
					if (r){
						$.post('sqlestado.php',{rut:row.usuario_rut,estado:row.usuario_estado},function(result){
							if (result.success){
								$('#dgusuario').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		//FUNCIONES DE ASOCIAR EXPORTADOR
		function AsociarExportador(){
			var row = $('#dgusuario').datagrid('getSelected');
			if (row){
				$('#dlgformasociarexp').dialog('open').dialog('setTitle','Nuevo Registro');
				cargarExportador(row.usuario_rut);
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		function cargarExportador(codigo){
			$('#dgexportador').datagrid({
				url:'sqllistarexportador.php?codigo='+codigo,
				columns:[[
					{field:'aso_exportador_cod',title:'Exportador',width:400},
					{field:'exportador_nombre',title:'Nombre',width:400}									
				]]
			});
		}
		
		function NuevoExportador(){
			var row = $('#dgusuario').datagrid('getSelected');
			$('#dlgexpnuevo').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fmexportador').form('clear');
			url = 'sqlguardarexportador.php?usuario_rut='+row.usuario_rut
		}
		
		function guardarExportador(){
			var row = $('#dgusuario').datagrid('getSelected');
			if (row){				
				$('#fmexportador').form('submit',{
				url:url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgexpnuevo').dialog('close');		// close the dialog	
						$('#dgexportador').datagrid('reload');
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
			}
		}
		
		function editarExportador(){
			var row = $('#dgusuario').datagrid('getSelected');
			var row2 = $('#dgexportador').datagrid('getSelected');
			if (row2){
				$('#dlgexpnuevo').dialog('open').dialog('setTitle','Editar Registro');
				$('#fmexportador').form('clear');
				$('#fmexportador').form('load',row2);
				url = 'sqlactualizarExportador.php?id='+row2.usuario_rut;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		function EliminarExportador(){
			var row = $('#dgexportador').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea Quitar el registro?'+row.id_detalle,function(r){
					if (r){
						$.post('sqlquitarexportador.php',{id:row.id_detalle},function(result){
							if (result.success){
								$('#dgexportador').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		
		
		//cargar datagrid, comboox
		$(function(){ 
			$('#aso_exportador_cod').combogrid({
				panelWidth: 430,
				mode: 'remote',
				url: 'cboexportadorgrid.php',
				idField: 'aso_exportador_cod',
				textField: 'exportador_nombre',
				columns: [[
					{field:'aso_exportador_cod',title:'Codigo',width:100,sortable:true},
					{field:'exportador_nombre',title:'Nombre',width:300,sortable:true}
				]]
			});
			
		});
		
		function formato_rut(texto, activo) { 
			var invertido = ""; 
			var dtexto = ""; 
			var cnt = 0; 
			var i=0; 
			var j=0; 
			var largo = "";     
			if (activo) { 
					  texto = formato_rut(texto, false) 
					  crut = formato_rut(texto, false)
					  largo = texto.length; 
					  largo2 = texto.length; 
					if (largo > 0 )
					{
					 for ( i=0; i <crut.length ; i++ )
						if ( crut.charAt(i) != ' ' && crut.charAt(i) != '.' && crut.charAt(i) != '-' )
						{
							tmpstr = tmpstr + crut.charAt(i);
						}
						rut = tmpstr;
						largo2 = crut.length;
					
						if ( largo2 > 2 )
						
							rut = crut.substring(0, largo2 - 1);
						
						else
							rut = crut.charAt(0);
					
						    dv = crut.charAt(largo2-1);
					    if ( rut == null || dv == null )
						return 0;
					
						var dvr = '0';
						suma = 0;
						mul  = 2;
					    
						for (i= rut.length-1 ; i>= 0; i--)
						{
							suma = suma + rut.charAt(i) * mul;
							if (mul == 7)
								mul = 2;
							else
								mul++;
						}
					
						res = suma % 11;
						
						if (res==1)
							dvr = 'k';
						else if (res==0)
							dvr = '0';
						else
						{
							dvi = 11-res;
							dvr = dvi + "";
						}
					
						if ( dvr != dv.toLowerCase() )
						{
							$.messager.alert('Error','El Rut Ingreso es Invalido','error');
							
							return "";
						}
						//alert('El Rut Ingresado es Correcto!');
//						Objeto.focus()
//						return true; 
					  for ( i=(largo-1),j=0; i>=0; i--,j++ ) 
						invertido = invertido + texto.charAt(i);           
					  dtexto = dtexto + invertido.charAt(0); 
					  dtexto = dtexto + '-';           
							  for ( i=1,j=2; i<largo; i++,j++ ) 
							  { 
								//alert("i=[" + i + "] j=[" + j +"]" ); 
										if ( cnt == 3 ) 
										{ 
										  dtexto = dtexto + '.'; 
										  j++; 
										  dtexto = dtexto + invertido.charAt(i); 
										  cnt = 1; 
										} 
										else 
										{  
										  dtexto = dtexto + invertido.charAt(i); 
										  cnt++; 
										} 
							  } 
					  invertido = ""; 
					  for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ ) 
						invertido = invertido + dtexto.charAt(i); 
					  if (invertido == '-') invertido = "" 
					  texto = invertido; 
					 					 
					 
					 
				} else { 
				
				$.messager.alert('Error','El Rut Ingreso es Invalido','error');
				return "";
			
				}
				} else { 
					var tmpstr = ""; 
					for ( i=0; i < texto.length ; i++ ) 
					if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' ) 
						tmpstr = tmpstr + texto.charAt(i); 
					texto = tmpstr; 
				} 
				return texto; 
			}

	</script>
</body>
</html>