<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Planillas</title>
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/metro-orange/easyui.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/mobile.css">  
    <link rel="stylesheet" type="text/css" href="../../jquery-easyui-1.4.5/themes/icon.css">  
    <link href="../../css/estilo.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.min.js"></script>  
    <script type="text/javascript" src="../../js/jquery-1.8.0.min.js"></script>
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.min.js"></script> 
    <script type="text/javascript" src="../../jquery-easyui-1.4.5/jquery.easyui.mobile.js"></script>
      <script type="text/javascript" src="../../jquery-easyui-1.4.5/locale/easyui-lang-es.js"></script>    
</head>

<body>
    <div class="easyui-navpanel">
    <header>
        <div class="m-toolbar">
            <div class="m-title">Panel Header</div>
        </div>
        <div class="m-left">
                    <a href="#" class="easyui-linkbutton m-back" data-options="plain:true,outline:true,back:true">Back</a>
                </div>
    </header>
    <table id="dgExportador" title="Exportador" class="easyui-datagrid" url="sqllistar.php" border="0" toolbar="#toolbar" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:15,pageList:[5,10,15,20]">
    <thead>
    	<tr>
            <th field="exportador_cod" width="95">Código</th>
            <th field="cliente_nombre" width="100">Cliente</th>
            <th field="exportador_rut" width="100">Rut</th>
            <th field="exportador_nombre" width="100">Nombre</th>
            <th field="exportador_direccion" width="100">Direccion</th>
            <th field="exportador_ciudad" width="100">Ciudad</th>
            <th field="exportador_giro" width="100">Giro</th>
            <th field="exportador_telefono" width="100">Teléfono</th>
            <th field="exportador_contacto" width="100">Contacto</th>
            <th field="exportador_mail" width="100">Mail</th>
            <th field="exportador_representante" width="100">Representante</th>
            <th field="exportador_estado" width="100">Estado</th>
    	</tr>
    </thead>
    </table>

    <div id="toolbar">
        <div style ="float:left">
        	<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="nuevoReg()">Nuevo</a>
        	<a href="#" class="easyui-linkbutton" iconCls="icon-edit" plain="true" onclick="editarReg()">Editar</a>
        	<a href="#" class="easyui-linkbutton" iconCls="icon-estado" plain="true" onclick="CambiarEstado()">Cambiar Estado</a>
        	
        </div>
        <div style="float:right">
            	<a href="#" class="easyui-linkbutton"  iconCls="icon-filtro" plain="true" onclick="$('#dlgFiltro').dialog('open').dialog('setTitle','Filtro')">Filtrar</a>
                <a href="#" class="easyui-linkbutton"  iconCls="icon-filtroCancelar" plain="true" onclick="filtro()">Mostrar Todos</a>
        </div>	
    </div>
    <footer>
        <div class="m-toolbar">
            <div class="m-title">Control Proceso Inglobo</div>
        </div>
    </footer>
</div>
    
<div id="dlgform" class="easyui-dialog" style="width:800px;height:auto;padding:10px 10px" closed="true" buttons="#dlg-buttons" modal="true">

	<div class="ftitle">Información de Exportador</div>
	<form id="fm" method="post" novalidate>
		<table border="0" width="700" cellpadding="5">
        	<tr>
            	<td colspan="2">Datos Exportador</td>
                <td colspan="2"></td>
            </tr>
            <tr>
            	<td>Código</td>
                <td><input name="exportador_cod" id="exportador_cod" class="easyui-validatebox" required="required" maxlength="50" style="width:200px;"></td>
               <td>Telefono</td>
                <td><input name="exportador_telefono" id="exportador_telefono" class="easyui-validatebox" maxlength="50" style="width:200px;"></td>
            </tr>
        	<tr>
            	<td>Rut:</td>
                <td><input name="exportador_rut" id="exportador_rut" class="easyui-validatebox" maxlength="12" onblur="this.value =formato_rut(this.value,true)" style="width:200px;"></td>
                <td>Contacto</td>
                <td><input name="exportador_contacto" id="exportador_contacto" class="easyui-validatebox"  maxlength="50" style="width:200px;"></td>
            </tr>
            <tr>
                <td>Cliente</td>
                <td><input name="cliente_cod"  id="cliente_cod" class="easyui-combobox" editable="false" style="width:205px;" required="required" data-options="valueField: 'cliente_cod', textField:'cliente_nombre', url:'sqlcbocliente.php', panelHeight:'auto'" ></td> 
                <td>Mail</td>
                <td><input name="exportador_mail" id="exportador_mail" class="easyui-validatebox"  maxlength="50" style="width:200px;"></td>    
            </tr>
            <tr>
            	<td>Nombre</td>
                <td><input name="exportador_nombre" id="exportador_nombre" class="easyui-validatebox" required="required" maxlength="50" style="width:200px;"></td>
                <td>Representante</td>
                <td><input name="exportador_representante" id="exportador_representante" class="easyui-validatebox"  maxlength="50" style="width:200px;"></td>   
            </tr>
            <tr>
            	<td>Dirección</td>
                <td><input name="exportador_direccion" id="exportador_direccion" class="easyui-validatebox"  maxlength="50" style="width:200px;"></td>
            </tr>
            <tr>
            	<td>Ciudad</td>
                <td><input name="exportador_ciudad" id="exportador_ciudad" class="easyui-validatebox"  maxlength="50" style="width:200px;"></td>
            </tr>
            <tr>
            	<td>Giro</td>
                <td><input name="exportador_giro" id="exportador_giro" class="easyui-validatebox"  maxlength="50" style="width:200px;"></td>
            </tr>
        </table>          
	</form>
</div>
 <div id="dlg-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarReg()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgform').dialog('close')">Cancelar</a>
</div>

<div id="dlgFiltro" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgFiltro-buttons" modal="true">
		<div class="fitem">
    		<label>Rut:</label>
            <input id="usuario_rut_filtro" class="easyui-validatebox">
    	</div>	
    	<div class="fitem">
    		<label>Nombre:</label>
            <input id="usuario_nombre_filtro" class="easyui-validatebox">
    	</div>
        <div class="fitem">
           	<label>Tipo:</label>
			<input id="usuario_tipo_filtro" name="usuario_tipo_filtro" class="easyui-combobox" url="CboTipoFiltro.json" panelHeight="auto" editable="false" valueField="value" textField="text" required="required">
        </div>
        <div class="fitem">
           	<label>Estado:</label>
			<input id="usuario_estado_filtro" name="usuario_estado_filtro" class="easyui-combobox" url="CboEstado.json" panelHeight="auto" editable="false" valueField="value" textField="text" required="required">
        </div>
        <div class="fitem">
           	<label>Perfil:</label>
			<input name="perfilFiltro"  id="perfilFiltro" class="easyui-combobox" editable="false" data-options= "valueField:'tipousuario_id',textField:'tipousuario_nombre',url:'sqlcboperfilesFiltro.php',panelHeight:'auto'" >
        </div>
        <br />
</div>
<div id="dlgFiltro-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="filtro()">Filtrar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgFiltro').dialog('close')">Cancelar</a>
</div>  
<!--DATAGRID DE PACKING-->
<div id="dlgformcrearpacking" class="easyui-dialog" style="width:750px;height:450px;padding:10px 10px" closed="true" buttons="#dlg-buttonscrearpacking" modal="true">
    <table id="dgpacking" title="Packing" class="easyui-datagrid" border="0" toolbar="#toolbar3" pagination="true" rownumbers="true" fitColumns="true" singleSelect="true" fit="true" data-options="pageSize:8,pageList:[8,15,20]">
    </table>

    <div id="toolbar3">
        <div style ="float:left">
            <a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="NuevoPacking()">Agregar</a>
            <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" plain="true" onclick="EliminarPacking()">Quitar</a>
        </div>
    </div>
</div>
 <div id="dlg-buttonscrearpacking" style="width:inherit;text-align:center;">
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgformcrearpacking').dialog('close')">Cerrar</a>
</div>

<div id="dlgpacnuevo" class="easyui-dialog" style="width:400px;height:auto;padding:10px 10px" closed="true" buttons="#dlgpacnuevo-buttons" modal="true">

	<div class="ftitle">Información de Packing</div>
	<form id="fmpacking" method="post" novalidate>
		
        <div class="fitem">
           	<label>Packing:</label>
			<input id="packing_cod" name="packing_cod" editable="false" style="width:250px;">
        </div>         
	</form>
</div>
 <div id="dlgpacnuevo-buttons" style="width:inherit;text-align:center;">
   	<a href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="guardarPacking()">Guardar</a>
    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" onclick="javascript:$('#dlgpacnuevo').dialog('close')">Cancelar</a>
</div>

<!--comienza las funciones-->
<script type="text/javascript">
	
	function filtro(){  
		    $('#dgExportador').datagrid('load',{  
        		
		        usuario_rut_filtro: $('#usuario_rut_filtro').val(), 
				usuario_nombre_filtro: $('#usuario_nombre_filtro').val(),
				usuario_tipo_filtro: $('#usuario_tipo_filtro').combobox('getValue'), 
				usuario_estado_filtro: $('#usuario_estado_filtro').combobox('getValue'), 
				perfilFiltro: $('#perfilFiltro').combobox('getValue'),
		    });
			 $('#dlgFiltro').dialog('close'); 
			 $('#usuario_rut_filtro').val('');
			 $('#usuario_nombre_filtro').val('');
			 $('#usuario_tipo_filtro').combobox('setValue','');	 
			 $('#usuario_estado_filtro').combobox('setValue','');	
			 $('#perfilFiltro').combobox('setValue','');
		}  
		
		var url;
		function nuevoReg(){
			$('#dlgform').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fm').form('clear');
			$('#exportador_cod').attr("disabled",false);
			$('#exportador_cod').focus();
			url = 'sqlguardar.php';
		}
		function editarReg(){
			var row = $('#dgExportador').datagrid('getSelected');
			if (row){
				$('#dlgform').dialog('open').dialog('setTitle','Editar Registro');
				$('#fm').form('clear');
				$('#fm').form('load',row);
				$('#exportador_cod').attr("disabled",true);
				
				//$('#perfil').combobox('getValue');
				url = 'sqlactualizar.php?id='+row.exportador_cod;
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}

        function guardarReg(){
			$('#fm').form('submit',{
				url: url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgform').dialog('close');		// close the dialog
						$('#dgExportador').datagrid('reload');	// reload the user data
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
		}
		function CambiarEstado(){
			var row = $('#dgExportador').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea cambiar el estado del registro?',function(r){
					if (r){
						$.post('sqlestado.php',{exportador_cod:row.exportador_cod,estado:row.exportador_estado},function(result){
							if (result.success){
								$('#dgExportador').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		//FUNCIONES DE ASOCIAR PACKING
		function AsociarPacking(){
			var row = $('#dgExportador').datagrid('getSelected');
			if (row){
				$('#dlgformcrearpacking').dialog('open').dialog('setTitle','Nuevo Registro');
				cargarPacking(row.exportador_cod);
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		function cargarPacking(codigo){
			$('#dgpacking').datagrid({
				url:'sqllistarpacking.php?codigo='+codigo,
				columns:[[
					{field:'packing_cod',title:'Id',width:400},
					{field:'packing_nombre',title:'Nombre',width:400}									
				]]
			});
		}
		
		function NuevoPacking(){
			var row = $('#dgExportador').datagrid('getSelected');
			$('#dlgpacnuevo').dialog('open').dialog('setTitle','Nuevo Registro');
			$('#fmpacking').form('clear');
			url = 'sqlguardarpacking.php?exportador_cod='+row.exportador_cod;
		}
		
		function guardarPacking(){
			var row = $('#dgExportador').datagrid('getSelected');
			if (row){				
				$('#fmpacking').form('submit',{
				url:url,
				onSubmit: function(){
					return $(this).form('validate');
				},
				success: function(data){
					if (data=="Datos Grabados" || data=="Datos Modificados"){
						$.messager.alert('Informacion',data,'info');
						$('#dlgpacnuevo').dialog('close');		// close the dialog	
						$('#dgpacking').datagrid('reload');
					} else {
						$.messager.alert('Error',data,'error');
					}
				}
			});
			}
		}
		
		function EliminarPacking(){
			var row = $('#dgpacking').datagrid('getSelected');
			if (row){
				$.messager.confirm('Confirmar','¿Esta seguro que desea Quitar el registro?'+row.id_detalle,function(r){
					if (r){
						$.post('sqlquitarpacking.php',{id:row.id_detalle},function(result){
							if (result.success){
								$('#dgpacking').datagrid('reload');	// reload the user data
							} else {
								$.messager.show({	// show error message
									title: 'Error',
									msg: result.msg
								});
							}
						},'json');
					}
				});
			}else{
				$.messager.alert('Advertencia','Seleccione un registro','warning');			
			}
		}
		
		
		
		//cargar datagrid, comboox
		$(function(){ 
			$('#packing_cod').combogrid({
				panelWidth: 430,
				mode: 'remote',
				url: 'cbopackinggrid.php',
				idField: 'packing_cod',
				textField: 'packing_nombre',
				columns: [[
					{field:'packing_cod',title:'Codigo',width:100,sortable:true},
					{field:'packing_nombre',title:'Nombre',width:300,sortable:true}
				]]
			});
			
		});
		
		//formato rut		
		function formato_rut(texto, activo) { 
			var invertido = ""; 
			var dtexto = ""; 
			var cnt = 0; 
			var i=0; 
			var j=0; 
			var largo = "";     
			if (activo) { 
					  texto = formato_rut(texto, false) 
					  crut = formato_rut(texto, false)
					  largo = texto.length; 
					  largo2 = texto.length; 
					if (largo > 0 )
					{
					 for ( i=0; i <crut.length ; i++ )
						if ( crut.charAt(i) != ' ' && crut.charAt(i) != '.' && crut.charAt(i) != '-' )
						{
							tmpstr = tmpstr + crut.charAt(i);
						}
						rut = tmpstr;
						largo2 = crut.length;
					
						if ( largo2 > 2 )
						
							rut = crut.substring(0, largo2 - 1);
						
						else
							rut = crut.charAt(0);
					
						    dv = crut.charAt(largo2-1);
					    if ( rut == null || dv == null )
						return 0;
					
						var dvr = '0';
						suma = 0;
						mul  = 2;
					    
						for (i= rut.length-1 ; i>= 0; i--)
						{
							suma = suma + rut.charAt(i) * mul;
							if (mul == 7)
								mul = 2;
							else
								mul++;
						}
					
						res = suma % 11;
						
						if (res==1)
							dvr = 'k';
						else if (res==0)
							dvr = '0';
						else
						{
							dvi = 11-res;
							dvr = dvi + "";
						}
					
						if ( dvr != dv.toLowerCase() )
						{
							$.messager.alert('Error','El Rut Ingreso es Invalido','error');
							
							return "";
						}
						//alert('El Rut Ingresado es Correcto!');
//						Objeto.focus()
//						return true; 
					  for ( i=(largo-1),j=0; i>=0; i--,j++ ) 
						invertido = invertido + texto.charAt(i);           
					  dtexto = dtexto + invertido.charAt(0); 
					  dtexto = dtexto + '-';           
							  for ( i=1,j=2; i<largo; i++,j++ ) 
							  { 
								//alert("i=[" + i + "] j=[" + j +"]" ); 
										if ( cnt == 3 ) 
										{ 
										  dtexto = dtexto + '.'; 
										  j++; 
										  dtexto = dtexto + invertido.charAt(i); 
										  cnt = 1; 
										} 
										else 
										{  
										  dtexto = dtexto + invertido.charAt(i); 
										  cnt++; 
										} 
							  } 
					  invertido = ""; 
					  for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ ) 
						invertido = invertido + dtexto.charAt(i); 
					  if (invertido == '-') invertido = "" 
					  texto = invertido; 
					 					 
					 
					 
				} else { 
				
				$.messager.alert('Error','El Rut Ingreso es Invalido','error');
				return "";
			
				}
				} else { 
					var tmpstr = ""; 
					for ( i=0; i < texto.length ; i++ ) 
					if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' ) 
						tmpstr = tmpstr + texto.charAt(i); 
					texto = tmpstr; 
				} 
				return texto; 
			}

	</script>
</body>
</html>